; -------------------------------------------------------------------------------------------------------------- ;
; Beach Head - In game variables
; -------------------------------------------------------------------------------------------------------------- ;
; Memory Layout
; -------------------------------------------------------------------------------------------------------------- ;
BH_MemVicBase               = VIC_MemBase_0         ; $0000-$3fff
BH_MemScreenStatus          = BH_MemVicBase + $0400 ; $0400-$07ff - Chapter Status Screen
BH_MemBasic                 = BH_MemVicBase + $0800 ; 

BH_MemScreenSave            = BH_MemVicBase + $3c00 ; .hbu012.

BH_MemCodeLo                = $1e00                 ; $1e00-$4000
BH_MemVicGfx                = VIC_MemBase_1         ; $4000-$7fff
BH_MemScreenSetA            = BH_MemVicGfx + $0000              ; .hbu012. - TabVicMemControlSetA
BH_MemScreenValA              = VIC_Video_0000 + VIC_CharS_0800 ; .hbu012. - VIC_Video_4000 + VIC_CharS_4800
BH_MemScreenSetB            = BH_MemVicGfx + $0400              ; .hbu012. - TabVicMemControlSetB
BH_MemScreenValB              = VIC_Video_0400 + VIC_CharS_0800 ; .hbu012. - VIC_Video_0800 + VIC_CharS_0800
BH_MemCharSet               = BH_MemVicGfx + $0800              ; .hbu012.
BH_MemSprites               = BH_MemVicGfx + $1000  ; 
BH_MemCodeHi                = $6580                 ; up to $bc000
;BH_MemScreenSave            = $bc00                 ; .hbu012.
BH_MemScreenSaveLen           = BH_Scrn_Stat_Rows * BH_Scrn_RowLen ; 
BH_MemStrand                = $c000                 ; .hbu016. - up to $cfff
BH_Mem_unused_02            = $f000                 ; up to $feff
BH_MemKernal                = $ff00                 ; up to $ffff
; -------------------------------------------------------------------------------------------------------------- ;
; Screens
; -------------------------------------------------------------------------------------------------------------- ;
BH_Scrn_GfxCharSets         = BH_MemCharSet           ; 

BH_Scrn_Gfx                 = BH_MemScreenSetA        ; 
BH_Scrn_Gfx_A               = BH_MemScreenSetA        ; 
BH_Scrn_Gfx_B               = BH_MemScreenSetB        ; 
BH_Scrn_Gfx_Save            = BH_MemScreenSave        ; 
BH_Scrn_Stat                = BH_MemScreenStatus      ; $0400
; -------------------------------------------------------------------------------------------------------------- ;
BH_Scrn_Gfx_Rows            = $14                     ; 
BH_Scrn_RowLen              = $28                     ; 
BH_Scrn_Row_01              = $00 * BH_Scrn_RowLen    ; $000 - 01 - $14 graphics rows
BH_Scrn_Row_02              = $01 * BH_Scrn_RowLen    ; $028 - 02
BH_Scrn_Row_03              = $02 * BH_Scrn_RowLen    ; $050 - 03
BH_Scrn_Row_04              = $03 * BH_Scrn_RowLen    ; $078 - 04
BH_Scrn_Row_05              = $04 * BH_Scrn_RowLen    ; $0a0 - 05
BH_Scrn_Row_06              = $05 * BH_Scrn_RowLen    ; $0c8 - 06
BH_Scrn_Row_07              = $06 * BH_Scrn_RowLen    ; $0f0 - 07
BH_Scrn_Row_08              = $07 * BH_Scrn_RowLen    ; $118 - 08
BH_Scrn_Row_09              = $08 * BH_Scrn_RowLen    ; $140 - 09
BH_Scrn_Row_0a              = $09 * BH_Scrn_RowLen    ; $168 - 10
BH_Scrn_Row_0b              = $0a * BH_Scrn_RowLen    ; $190 - 11
BH_Scrn_Row_0c              = $0b * BH_Scrn_RowLen    ; $1b8 - 12
BH_Scrn_Row_0d              = $0c * BH_Scrn_RowLen    ; $1e0 - 13
BH_Scrn_Row_0e              = $0d * BH_Scrn_RowLen    ; $208 - 14
BH_Scrn_Row_0f              = $0e * BH_Scrn_RowLen    ; $230 - 15
BH_Scrn_Row_10              = $0f * BH_Scrn_RowLen    ; $258 - 16
BH_Scrn_Row_11              = $10 * BH_Scrn_RowLen    ; $280 - 17
BH_Scrn_Row_12              = $11 * BH_Scrn_RowLen    ; $2a8 - 18
BH_Scrn_Row_13              = $12 * BH_Scrn_RowLen    ; $2d0 - 19
BH_Scrn_Row_14              = $13 * BH_Scrn_RowLen    ; $2f8 - 20

BH_Scrn_Stat_Rows           = $05                     ; 
BH_Scrn_Stat_Row_01         = $14 * BH_Scrn_RowLen    ; $320 - 21 - $05 status rows
BH_Scrn_Stat_Row_02         = $15 * BH_Scrn_RowLen    ; $348 - 22
BH_Scrn_Stat_Row_03         = $16 * BH_Scrn_RowLen    ; $370 - 23
BH_Scrn_Stat_Row_04         = $17 * BH_Scrn_RowLen    ; $398 - 24
BH_Scrn_Stat_Row_05         = $18 * BH_Scrn_RowLen    ; $3c0 - 25 - 3e7
; -------------------------------------------------------------------------------------------------------------- ;
; Status Screen Updates
; -------------------------------------------------------------------------------------------------------------- ;
BH_Scrn_Stat_LeTxt          = $05                     ; tab text  left
BH_Scrn_Stat_LeVal          = $0c                     ; tab value left
BH_Scrn_Stat_RiTxt          = $16                     ; tab text  right
BH_Scrn_Stat_RiVal          = $1c                     ; tab value right

BH_Scrn_Stat_LenAmmo        = $0a                     ; 
BH_Scrn_Stat_LenScore       = $06                     ; 

BH_Scrn_Stat_Box            = $12                     ; tab central box

BH_Scrn_GaOvr_LeTxt         = $0a                     ; tab game over       left
BH_Scrn_GaOvr_RiTxt         = $0e                     ; tab game over score right
BH_Scrn_GaOvr_RiVal         = $15                     ; tab game over value right

BH_Scrn_Ready_LeTxt         = $09                     ; tab get ready text  right
BH_Scrn_Ready_RiTxt         = $15                     ; tab get ready value right
; -------------------------------------------------------------------------------------------------------------- ;
; Colors: Status
; -------------------------------------------------------------------------------------------------------------- ;
BH_Scrn_Stat_ColorShips     = LT_BLUE ; 
BH_Scrn_Stat_ColorCavePass  = WHITE   ; 
BH_Scrn_Stat_ColorTanks     = LT_BLUE ; 
BH_Scrn_Stat_ColorShotMiss  = WHITE   ; 
BH_Scrn_Stat_ColorShotLong  = LT_GREY ; 
BH_Scrn_Stat_ColorShotShort = LT_GREY ; 
; -------------------------------------------------------------------------------------------------------------- ;
; Misc
; -------------------------------------------------------------------------------------------------------------- ;
BH_BayPassageLeftPosX       = $e8 ; bay opening left border        
BH_BayRightAdjustPosY       = $13 ; adjustement if entered through opening - added $03 - no seek throughs anymore
BH_BayFleetMyStartPosX_Msb  = $00 ; $01 ; 
BH_BayFleetMyStartPosX      = $c0 ; $40 ; startpos chase myFleet in bay
BH_BayFleetMyStartPosY      = BH_BayFleetHitCavePosY ; $32 ; 
BH_BayFleetEnemyStartPosX   = $6e ; startpos chase myFleet in bay
BH_BayFleetEnemyStartPosY   = $b2 ; 
BH_BayFleetHitCavePosX      = $83 ; 
BH_BayFleetHitCavePosY      = $4a ; 
BH_BayFleetChaseGoPosX      = $a0 ; startpos chase myFleet in bay
BH_BayFleetChaseGoPosY      = $aa ; 
BH_BayFleetLeftCavePosX     = $a0 ; startpos chase myFleet in bay
BH_BayFleetLeftCavePosY     = $a2 ; 
BH_BayFleetHitBeachPosX     = $62 ; myFleet touches the beach
BH_BayFleetHitBeachPosY     = $b4 ; 
BH_FleetOverlayPosX         = $08 ; both fleets mix
BH_FleetOverlayPosY         = $08 ; 
BH_BeachMinPosX             = $60 ; 
BH_BeachMaxPosX             = BH_BeachMinPosX + $08 ; 
BH_BeachMinPosY             = $b2 ; 
BH_BeachMaxPosY             = BH_BeachMinPosY + $08 ; 
BH_ShipsMax                 = $0a ; 
BH_TanksMax                 = $08 ; 
; -------------------------------------------------------------------------------------------------------------- ;
; Sprite Numbers
; -------------------------------------------------------------------------------------------------------------- ;
BH_BeachSprtNoMyTank        = $00 ; $01
BH_BeachSprtNoMyShot        = $01 ; $02
BH_BeachSprtNoEneShot       = $02 ; $04
BH_BeachSprtNoCannon        = $03 ; $08
BH_BeachSprtNoTank          = $04 ; $10
BH_BeachSprtNoMacGun        = $05 ; $20
BH_BeachSprtNoTurret        = $06 ; $40
BH_BeachSprtNo_07           = $07 ; $80
; -------------------------------------------------------------------------------------------------------------- ;
; Colors: Sprite
; -------------------------------------------------------------------------------------------------------------- ;
BH_SprtColorCaveTorp_1      = ORANGE   ; 
BH_SprtColorCaveTorp_2      = LT_GREEN ; 
BH_SprtColorCaveTorp_3      = PURPLE   ; 
BH_SprtColorCaveTorp_4      = LT_BLUE  ; .hbu008. - follower torpedo #4
BH_SprtColorFleetMy         = WHITE    ; 
BH_SprtColorFleetEnemy      = WHITE    ; 
BH_SprtColorShip            = WHITE    ; 
BH_SprtColorShipEnemy       = BLACK    ; 
BH_SprtColorShipSplash      = WHITE    ; 
BH_SprtColorShipCannon      = WHITE    ; 
BH_SprtColorShipBullet      = ORANGE   ; 
BH_SprtColorShipBulletE     = BLACK    ; enemy
BH_SprtColorShipExplode     = ORANGE   ; 
BH_SprtColorShipExplodeBkgr = RED      ; 
BH_SprtColorPlane           = BLACK    ; 
BH_SprtColorPlaneBullet     = ORANGE   ; 
BH_SprtColorPlaneExplode    = YELLOW   ; 
BH_SprtColorPlaneExpl_MC0   = ORANGE   ; 
BH_SprtColorPlaneExpl_MC1   = WHITE    ; 
BH_SprtColorPlaneExpl_Off   = BLACK    ; 
BH_SprtColorTransp          = BROWN    ; 
BH_SprtColorTranspExplode   = YELLOW   ; 
BH_SprtColorTranspExpl_MC0  = ORANGE   ; 
BH_SprtColorTranspExpl_MC1  = BLACK    ; 
BH_SprtColorTranspExpl_Off  = BLACK    ; 
BH_SprtColorTankExplode     = RED      ; 
BH_SprtColorBeachTank       = ORANGE   ; 
BH_SprtColorBeachTankE      = PURPLE   ; enemy
BH_SprtColorBeachCannon     = BROWN    ; 
BH_SprtColorBeachMacGun     = BROWN    ; 
BH_SprtColorBeachTurret     = BLUE     ; 
BH_SprtColorBeachTankShot   = BLACK    ; 
BH_SprtColorBeachTankShotE  = BLACK    ; 
BH_SprtColorHillMyShot      = BLACK    ; 
BH_SprtColorHillHitExplode  = YELLOW   ; 
BH_SprtColorHillCapExplode  = ORANGE   ; 
BH_SprtColorHillCapRuin     = BLACK    ; 
BH_SprtColorHillCapPieces   = BROWN    ; 
BH_SprtColorHillResignFlag  = WHITE    ; 
; -------------------------------------------------------------------------------------------------------------- ;
; Start Positions
; -------------------------------------------------------------------------------------------------------------- ;
BH_SprtStartPlanePosX       = $a8 ; 
BH_SprtStartPlanePosY       = $8c ; 
BH_SprtTurnPlanePosX        = $84 ; 

BH_VesselCount              = $04 ; 

BH_Vessel1ScrnPosX          = $04 ; 
BH_Vessel2ScrnPosX          = $0b ; top of two
BH_Vessel3ScrnPosX          = $1e ; 
BH_Vessel4ScrnPosX          = $23 ; 

BH_Vessel1ScrnPosY          = $0c ; 
BH_Vessel2ScrnPosY          = $0d ; 
BH_Vessel3ScrnPosY          = $0d ; 
BH_Vessel4ScrnPosY          = $0e ; 

BH_CarrierScrnPosX          = $16 ; top of three
BH_CarrierScrnPosY          = $0c ; 
; -------------------------------------------------------------------------------------------------------------- ;
; Screen Positions
; -------------------------------------------------------------------------------------------------------------- ;
BH_Vessel1ScrnPos           = [[BH_Vessel1ScrnPosY - $01] * BH_Scrn_RowLen] + BH_Vessel1ScrnPosX ; .hbu014.
BH_Vessel2ScrnPos           = [[BH_Vessel2ScrnPosY - $01] * BH_Scrn_RowLen] + BH_Vessel2ScrnPosX ; .hbu014.
BH_Vessel3ScrnPos           = [[BH_Vessel3ScrnPosY - $01] * BH_Scrn_RowLen] + BH_Vessel3ScrnPosX ; .hbu014.
BH_Vessel4ScrnPos           = [[BH_Vessel4ScrnPosY - $01] * BH_Scrn_RowLen] + BH_Vessel4ScrnPosX ; .hbu014.
BH_CarrierScrnPos           = [[BH_CarrierScrnPosY - $01] * BH_Scrn_RowLen] + BH_CarrierScrnPosX ; .hbu014.

BH_Vessel1SprtPosX          = [[BH_Vessel1ScrnPosX + $01] * $08] + $10 ; .hbu014.
BH_Vessel2SprtPosX          = [[BH_Vessel2ScrnPosX + $01] * $08] + $10 ; .hbu014.
BH_Vessel3SprtPosX          = [[BH_Vessel3ScrnPosX + $01] * $08] + $10 ; .hbu014.
BH_Vessel4SprtPosX          = [[BH_Vessel4ScrnPosX + $01] * $08] + $10 ; .hbu014.

BH_Vessel1SprtPosY          = [[BH_Vessel1ScrnPosY - $01] * $08] + $32 ; .hbu014.
BH_Vessel2SprtPosY          = [[BH_Vessel2ScrnPosY - $01] * $08] + $32 ; .hbu014.
BH_Vessel3SprtPosY          = [[BH_Vessel3ScrnPosY - $01] * $08] + $32 ; .hbu014.
BH_Vessel4SprtPosY          = [[BH_Vessel4ScrnPosY - $01] * $08] + $32 ; .hbu014.

BH_CarrierSprtPosX          = [[BH_CarrierScrnPosX + $01] * $08] + $10 ; .hbu014.
BH_CarrierSprtPosY          = [[BH_CarrierScrnPosY - $01] * $08] + $32 ; .hbu014.
; -------------------------------------------------------------------------------------------------------------- ;
; Chapter Numbers
; -------------------------------------------------------------------------------------------------------------- ;
BH_ChapterIntro             = $00
BH_ChapterBayAreaMap        = $01
BH_ChapterCaveCrossings     = $02
BH_ChapterPlaneShootOut     = $03
BH_ChapterShipShootOut      = $04
BH_ChapterTanksOnBeach      = $05
BH_ChapterStormTheHill      = $06
; -------------------------------------------------------------------------------------------------------------- ;
; Chapter Timer Values
; -------------------------------------------------------------------------------------------------------------- ;
BH_DemoTimeMap              = $05
BH_DemoTimeBay              = $03
BH_DemoTimeCave             = $20
BH_DemoTimeSeaPlane         = $40
BH_DemoTimeSeaShip          = $30
BH_DemoTimeBeach            = $25
; -------------------------------------------------------------------------------------------------------------- ;
; Sprite Pointers and Storage
; -------------------------------------------------------------------------------------------------------------- ;
BH_SpriteDataLen            = $40
BH_SpriteStore              = BH_MemSprites

BH_SpritePointers_Chr       = BH_MemCharSet + $07f8   ; 

BH_SpritePointers_A         = BH_Scrn_Gfx_A + $03f8     ; $4bf8
BH_SpritePointer00_A        = BH_SpritePointers_A + $00 ; $4bf8
BH_SpritePointer01_A        = BH_SpritePointers_A + $01 ; $4bf9
BH_SpritePointer02_A        = BH_SpritePointers_A + $02 ; $4bfa
BH_SpritePointer03_A        = BH_SpritePointers_A + $03 ; $4bfb
BH_SpritePointer04_A        = BH_SpritePointers_A + $04 ; $4bfc
BH_SpritePointer05_A        = BH_SpritePointers_A + $05 ; $4bfd
BH_SpritePointer06_A        = BH_SpritePointers_A + $06 ; $4bfe
BH_SpritePointer07_A        = BH_SpritePointers_A + $07 ; $4bff

BH_SpritePointers_B         = BH_Scrn_Gfx_B + $03f8     ; $4ff8
BH_SpritePointer00_B        = BH_SpritePointers_B + $00 ; $4ff8
BH_SpritePointer01_B        = BH_SpritePointers_B + $01 ; $4ff9
BH_SpritePointer02_B        = BH_SpritePointers_B + $02 ; $4ffa
;BH_SpritePointer03_B        = BH_SpritePointers_B + $03 ; $4ffb - not directly used
;BH_SpritePointer04_B        = BH_SpritePointers_B + $04 ; $4ffc
;BH_SpritePointer05_B        = BH_SpritePointers_B + $05 ; $4ffd
;BH_SpritePointer06_B        = BH_SpritePointers_B + $06 ; $4ffe
;BH_SpritePointer07_B        = BH_SpritePointers_B + $07 ; $4fff
; -------------------------------------------------------------------------------------------------------------- ;
; Misc
; -------------------------------------------------------------------------------------------------------------- ;
Kernel_Vectors              = $ff00                   ; 
; -------------------------------------------------------------------------------------------------------------- ;
